<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0.1 (vB 3.5) - nulled by someone@mail.ru
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ########################## Update Moderator Cache ##########################
function update_gallery_mod_cache()
{
	global $db;
	$getmods = $db->query_read("SELECT * FROM " . TABLE_PREFIX ."adv_gallery_moderator ORDER BY catid, username");
	while ($moderators = $db->fetch_array($getmods))
	{
		$mods[] = $moderators;
	}
	build_datastore('gal_mod_cache', serialize($mods));
	$db->free_result($getmods);
	unset($moderators, $mods);
}

// ######################## Make Category Select Field ########################
function print_category_select($selectname, $selectedid = 0, $nonevalue = 'None', $title = '', $disablecat = false, $nonele = 0, $dowidth = false)
{
	global $catselect, $categorycache;

  echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
  echo '<td>' . $title . '</td>';
  echo '<td>';

  echo '<select class="bginput" name="' . $selectname . '" size="1">';
	if ($nonevalue)
	{
	  echo '<option value="' . $nonele . '">' . $nonevalue . '</option>';
	}

	if (empty($catselect))
	{
		$catselect = construct_categories($categorycache, 0, -1);
	}

	foreach ($catselect as $cats)
	{
    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
		$selected = '';
		if ($selectedid == $cats['catid'])
		{
			$selected = 'selected="selected"';
			$class = 'fjsel';
		}
		elseif ($cats['level'] <= 4)
		{
			$class = 'fjdpth' . $cats['level'];
		}
		else
		{
			$class = 'fjdpth';
		}

		$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . stripslashes($cats['title']) . '</option>';
	}

	echo $options;

  echo '</select>';
 	echo '</td></tr>';
	unset($options);
}

// ###################### Print Category Permissions Rows #####################
function print_category_perm_rows($catinfo, $cat = 0)
{
	global $counter, $vbulletin, $vbphrase, $categories, $hasperms;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$categories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b> <span class="smallfont">( <a href="vba_gallery_admin.php?do=resetperms&amp;catid=' . $cats['catid'] . '">[Reset]</a> <a href="vba_gallery_admin.php?do=denyperms&amp;catid=' . $cats['catid'] . '">[Deny All]</a> )</span></li>';
				$categories .= '<ul class="usergroups">';

				foreach ($vbulletin->usergroupcache AS $group)
				{
					if ($hasperms["$group[usergroupid]"]["$cats[catid]"])
					{
						$categories .= '<li class="col-c">[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
					else if ($hasperms["$group[usergroupid]"]["$cats[parent]"])
					{
						$hasperms["$group[usergroupid]"]["$cats[catid]"] = true;
						$categories .= '<li class="col-i">[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';

					}
					else
					{
						$categories .= '<li>[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
				}

				$categories .=  '</ul><br />';

				print_category_perm_rows($catinfo, $cats['catid']);
				$categories .=  '</ul>';
				$counter--;
			}
		}
	}
	return $categories;
}

// ######################## Print Permission Rows #############################
function print_permission_rows($category)
{
	global $vbphrase, $perms, $usergroup;

	print_description_row($vbphrase['general_options'], 0, 2, 'thead');
	print_yes_no_row(iif($category, $vbphrase['can_view_category'], $vbphrase['can_view_gallery']), 'usergroup[canviewgallery]', $perms['canviewgallery'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_view_thumbnails'], 'usergroup[canviewimages]', $perms['canviewimages'], iif($category, 'js_set_custom();'));

	print_yes_no_row($vbphrase['can_view_large_images'], 'usergroup[canviewlargimage]', $perms['canviewlargimage'], iif($category, 'js_set_custom();'));
	print_yes_no_row('Can view original images', 'usergroup[canvieworiginal]', $perms['canvieworiginal'], iif($category, 'js_set_custom();'));

	print_yes_no_row($vbphrase['moderate_this_groups_images'], 'usergroup[moderateimages]', $perms['moderateimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['moderate_this_groups_posts'], 'usergroup[moderateposts]', $perms['moderateposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_rate_images'], 'usergroup[canrateimages]', $perms['canrateimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_search_images'], 'usergroup[cansearchimages]', $perms['cansearchimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_send_images_friend'], 'usergroup[cansendimagetofriend]', $perms['cansendimagetofriend'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_send_ecards'], 'usergroup[cansendecard]', $perms['cansendecard'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_create_categories'], 'usergroup[cancreatecategories]', $perms['cancreatecategories'], iif($category, 'js_set_custom();'));

	if ($category)
	{
		print_yes_no_row($vbphrase['can_upload_images'], 'usergroup[canuploadimages]', $perms['canuploadimages'], 'js_set_custom();');
	}
	else
	{
		print_input_row($vbphrase['maxumum_user_categories'], 'usergroup[gallery_maxcats]', $usergroup['gallery_maxcats'], iif($category, 'js_set_custom();'));
	}

	if (!$category)
	{
		print_description_row($vbphrase['uploading_options'], 0, 2, 'thead');
		print_yes_no_row($vbphrase['can_upload_images'], 'usergroup[canuploadimages]', $perms['canuploadimages']);
		print_yes_no_row($vbphrase['can_upload_images_from_server'], 'usergroup[canuploadfromserver]', $perms['canuploadfromserver']);
		print_yes_no_row($vbphrase['can_upload_as_other_users'], 'usergroup[canuploadasuser]', $perms['canuploadasuser']);
		print_input_row($vbphrase['space_images_may_consume'], 'usergroup[gallery_maxdiskspace]', $usergroup['gallery_maxdiskspace']);
	}

	print_description_row($vbphrase['image_editing_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_edit_own_images'], 'usergroup[caneditimages]', $perms['caneditimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_own_images'], 'usergroup[candelete]', $perms['candelete'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_others_images'], 'usergroup[caneditothersimages]', $perms['caneditothersimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_others_images'], 'usergroup[candeleteothers]', $perms['candeleteothers'], iif($category, 'js_set_custom();'));

	print_description_row($vbphrase['posting_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_view_replies_to_images'], 'usergroup[canviewreplies]', $perms['canviewreplies'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_reply_to_images'], 'usergroup[canreplytoimages]', $perms['canreplytoimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_own_posts'], 'usergroup[caneditposts]', $perms['caneditposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_own_posts'], 'usergroup[candeleteposts]', $perms['candeleteposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_others_posts'], 'usergroup[caneditothersposts]', $perms['caneditothersposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_others_posts'], 'usergroup[candeleteothersposts]', $perms['candeleteothersposts'], iif($category, 'js_set_custom();'));

}

// ############################## Orphaned Files ##############################
function fetch_orphaned_files($dirname, $location = '')
{
	global $filenamecache, $folders, $vba_options, $ofiles, $fcount;

	if (is_dir($dirname))
	{
		if ($dh = @opendir($dirname))
		{
			$userid = str_replace('/', '', $location);
			while (($filename = @readdir($dh)) !== false)
			{
				if (!in_array($filename, array('.', '..', 'index.html', '.htaccess', '.htpassword')))
				{
					$fcount++;
					if (is_dir($dirname . '/' . $filename))
					{
						fetch_orphaned_files($dirname . '/' . $filename, $location . '/' . $filename);
					}
					else
					{
						$ofiles[] = $location . '/' . $filename;
					}
				}
			}
		}
	}
	return $ofiles;
}


// ######################### Print Settings ###########################
function print_adv_setting_group($grouptitle, $revert = 1)
{
	global $settingscache, $grouptitlecache, $debug, $session, $vbphrase, $settingphrase, $stylevar, $categorycache;

	print_table_header(
		$settingphrase["settinggroup_$grouptitlecache[$grouptitle]"]
		 . iif($debug AND !$revert,
		 	'<span class="normal">' .
			construct_link_code($vbphrase['edit'], "vba_cmps_admin.php?$session[sessionurl]do=editgroup&amp;grouptitle=$grouptitle") .
			construct_link_code($vbphrase['delete'], "vba_cmps_admin.php?$session[sessionurl]do=removegroup&amp;grouptitle=$grouptitle") .
			construct_link_code($vbphrase['add_setting'], "vba_cmps_admin.php?$session[sessionurl]do=addsetting&amp;grouptitle=$grouptitle") .
			'</span>'
		)
	);

	foreach ($settingscache[$grouptitle] AS $settingid => $setting)
	{
		if ($setting['varname'] == 'portal_pagevar' AND $revert OR ($setting['varname'] == 'portal_version'))
		{
			continue;
		}

		print_description_row(
			'<div class="smallfont" style="float:' . $stylevar['right'] . '">' .
			iif($debug AND !$revert, construct_link_code($vbphrase['edit'], "vba_cmps_admin.php?$session[sessionurl]do=editsetting&varname=$setting[varname]") . construct_link_code($vbphrase['delete'], "vba_cmps_admin.php?$session[sessionurl]do=removesetting&varname=$setting[varname]")) . ' ' . iif($revert, '&nbsp; &nbsp; ' . $vbphrase['use_default'] . ' <input ' . iif($setting['default'], 'checked="checked"') . ' type="checkbox" name="usedefault[' . $setting['varname'] . ']" value="1" />') . '</div>
			<div>' . $settingphrase["setting_$setting[varname]_title"] . '<a name="' . $setting['varname'] . '"></a></div>',
			0, 2, 'optiontitle" title="$vba_options[' . $setting['varname'] . ']"'
		);

		$description = '<div class="smallfont" title="$vboptions[' . $setting['varname'] . ']">' . $settingphrase["setting_$setting[varname]_desc"] . '</div>';
		$name = "setting[$setting[varname]]";

		switch ($setting['optioncode'])
		{
			case '':
				print_input_row($description, $name, $setting['value'], 1, 40, '', '', iif($revert, 'bginput" onfocus="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'textarea':
				print_textarea_row($description, $name, $setting['value'], 8, 40, '', '', '', iif($revert, 'bginput" onfocus="js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'yesno':
				print_yes_no_row($description, $name, $setting['value'], iif($revert, 'js_check_default(\'' . $setting['varname'] . '\');'));
				break;

			case 'catselect':

				$selectbox = '<select name="' . $name . '[]" multiple="multiple" style="width:275px" size="' . iif(sizeof($categorycache) > 10, 10, sizeof($categorycache)) . '">';

				$setting['value'] = explode(',', $setting['value']);
				foreach ($categorycache AS $cat)
				{
					$selectbox .= '<option value="' . $cat['catid'] . '" ' . iif(in_array($cat['catid'], $setting['value']),'selected="selected"') . '>' . str_repeat('--', $cat['level']) . $cat['title'] . '</option>';
				}
				$selectbox .= '</select>';

				print_label_row($description, $selectbox);
			break;

			default:
				eval("\$right = \"$setting[optioncode]\";");
				print_label_row($description, $right, '', 'top', $name);
		}
	}
}

// ####################### Update Settings Cache ##############################
function build_adv_settings()
{
	global $db, $vbulletin;

	$adv_options = array();
	$settings = $db->query_read("SELECT varname, value FROM " . TABLE_PREFIX . "adv_setting WHERE varname LIKE 'gallery%' OR varname LIKE 'global%'");
	while ($setting = $db->fetch_array($settings))
	{
		$adv_options["$setting[varname]"] = $setting['value'];
	}
	$db->free_result($settings);
	unset($setting);

	build_datastore('adv_gallery_opt', serialize($adv_options));
}
?>